;C prototype: void DrawBonusShadow (short x, short y, short h, void *sprite, void *dest);
;
;void DrawBonusShadow (register short x asm("%d0"),
;		     register short y asm("%d1"),
;		     register short h asm("%d2"),
;		     register void *sprite asm("%a1"),
;		     register void *dest asm("%a0"));

	xdef	_DrawBonusShadow

_DrawBonusShadow:
    dbf      d2,__suite__
    rts

__suite__:
    move.l   d3,-(a7)
    move.l   d4,-(a7)

    move.w   d1,d3
    lsl.w    #4,d1
    sub.w    d3,d1

    move.w   d0,d3
    lsr.w    #4,d3

    add.w    d3,d1
    add.w    d1,d1
    adda.w   d1,a0

    and.w    #$0F,d0
    cmpi.w   #7,d0
    bls.s    Pre_Boucle16_LSR

    moveq    #16,d1
    sub.w    d0,d1

    lsr.w    #1,d2
    bcs.s    _loop_Sprite16_MASK

    lea.l    -30(a0),a0
    bra.s    Milieu_Boucle16

_loop_Sprite16_MASK:
    move.l   (a0),d0
    move.l   6000(a0),d4
    
    ;lightplane
    move.l   d0,d3
    not.l    d3
    or.l     d4,d3
    
    ;darkplane
    or.l     d0,d4
    
    ; masque
    moveq.l  #-1,d0
    move.w   (a1)+,d0
    rol.l    d1,d0
    and.l    d0,(a0)
    and.l    d0,6000(a0)
    not.l    d0
    and.l    d0,d3
    and.l    d0,d4
    
    ; Zone d'ombres
    or.l     d3,(a0)
    or.l     d4,6000(a0)
    
    ;addq.l   #4,a1

Milieu_Boucle16:
    move.l   30(a0),d0
    move.l   6000+30(a0),d4
    
    ;lightplane
    move.l   d0,d3
    not.l    d3
    or.l     d4,d3
    
    ;darkplane
    or.l     d0,d4
    
    ; masque
    moveq.l  #-1,d0
    move.w   (a1)+,d0
    rol.l    d1,d0
    and.l    d0,30(a0)
    and.l    d0,6000+30(a0)
    not.l    d0
    and.l    d0,d3
    and.l    d0,d4
    
    ; Zone d'ombres
    or.l     d3,30(a0)
    or.l     d4,6000+30(a0)
    
    ;addq.l   #4,a1
    
    lea.l    60(a0),a0

    dbf      d2,_loop_Sprite16_MASK
    move.l   (a7)+,d4
    move.l   (a7)+,d3
    rts

Pre_Boucle16_LSR:
    lsr.w    #1,d2
    bcs.s    Boucle16_LSR

    lea.l    -30(a0),a0
    bra.s    Milieu_Boucle16_LSR

Boucle16_LSR:
    move.l   (a0),d1
    move.l   6000(a0),d4
    
    ;lightplane
    move.l   d1,d3
    not.l    d3
    or.l     d4,d3
    
    ;darkplane
    or.l     d1,d4
    
    ; masque
    moveq.l  #-1,d1
    move.w   (a1)+,d1
    swap     d1
    ror.l    d0,d1
    and.l    d1,(a0)
    and.l    d1,6000(a0)
    not.l    d1
    and.l    d1,d3
    and.l    d1,d4
    
    ; Zone d'ombres
    or.l     d3,(a0)
    or.l     d4,6000(a0)
    
    ;addq.l   #4,a1

Milieu_Boucle16_LSR:
    move.l   30(a0),d1
    move.l   6000+30(a0),d4
    
    ;lightplane
    move.l   d1,d3
    not.l    d3
    or.l     d4,d3
    
    ;darkplane
    or.l     d1,d4
    
    ; masque
    moveq.l  #-1,d1
    move.w   (a1)+,d1
    swap     d1
    ror.l    d0,d1
    and.l    d1,30(a0)
    and.l    d1,6000+30(a0)
    not.l    d1
    and.l    d1,d3
    and.l    d1,d4
    
    ; Zone d'ombres
    or.l     d3,30(a0)
    or.l     d4,6000+30(a0)
    
    ;addq.l   #4,a1

    lea.l    60(a0),a0

    dbf      d2,Boucle16_LSR
    move.l   (a7)+,d4
    move.l   (a7)+,d3
    rts
